//: ## Classes
//:
//: Each instance of a class is one oject held in memory.
//:
//: The object is passed around in the code (never copied, never duplicated).
//:
//: -------------------
//:
//: [◀  Previous Page](@previous)  |  [Next Page  ▶](@next)
//:
//: -------------------
//:


class Blueprint {
     
    // stored properties on the instance
    var storedProperty1: Int
    var storedProperty2: Double
    var storedProperty3: Bool
    var storedProperty4: String
    
    // type properties on the type
    static let typeProperty1:  Int = 1
    static let typeProperty2: Double = 2.0
    static let typeProperty3: Bool = true
    static let typeProperty4: String = "4.0"
    
    // default initialiser
    init() {
        print("initialising new object")
        self.storedProperty1 = 1
        self.storedProperty2 = 2.0
        self.storedProperty3 = true
        self.storedProperty4 = "4.0"
        print("initialised")
    }
    
    // instance method
    func printDescription() {
        let description = """
        \(storedProperty1)
        \(storedProperty2)
        \(storedProperty3)
        \(storedProperty4)
        """
        print(description)
    }
    
    // type method
    static func printTypeProperties() {
        let description = """
        \(typeProperty1)
        \(typeProperty2)
        \(typeProperty3)
        \(typeProperty4)
        """
        print(description)
    }
    
    // deinitialiser - about to be removed from RAM
    deinit {
        print("about to be destroyed")
    }
}


//:
//: -------------------
//:
//: ## Instances
//:
//: When creating a new instance an object is created as the result, and stored in RAM.
//:
//: -------------------
//:


var object1: Blueprint? = Blueprint() // initialised


//:
//: -------------------
//:
//: ## Instantiating Many Objects
//:
//: -------------------
//:


var object2: Blueprint? = Blueprint() // a new object
var object3: Blueprint? = Blueprint() // a new object
var object4: Blueprint? = Blueprint() // a new object


//:
//: -------------------
//:
//: ## Memory Management
//:
//: 1. Allocate memory and initialise object.
//:
//: 2. Do stuff.
//:
//: 3. Deinitialise object and remove from memory (which frees up space). 🪦
//:
//: -------------------
//:


class Example {
    init() {
        print("* initialise *")
    }
    
    func doStuff() {
        
    }
    
    deinit {
        print("* deinitialise *")
    }
}

var example: Example? = Example()  // Initialise object
example?.doStuff()                 // Do stuff
example = nil                      // Deinitialise object 🪦


//:
//: -------------------
//:
//: ## Memory Management in Action
//:
//: -------------------
//:


// how the memory management works
var reference2: Blueprint? = object1 // reference counter = 2
var reference3: Blueprint? = object1 // reference counter = 3
var reference4: Blueprint? = object1 // reference counter = 4

reference4 = nil // reference counter = 3
reference3 = nil // reference counter = 2
reference2 = nil // reference counter = 1
object1 = nil    // reference counter = 0 - deinitialised called 🪦


//:
//: -------------------
//:
//: [◀  Previous Page](@previous)  |  [Coding Task  ▶](@next)
//:
//: -------------------
//:
//: ## ![3 Days Of Swift Logo](3DaysIcon146.png) 3 Days Of Swift 
//:
//: © Copyright. All rights reserved.
//:
//: 🧕🏻🙋🏽‍♂️👨🏿‍💼👩🏼‍💼👩🏻‍💻💁🏼‍♀️👨🏼‍💼🙋🏻‍♂️🙋🏻‍♀️👩🏼‍💻🙋🏿💁🏽‍♂️🙋🏽‍♀️🙋🏿‍♀️🧕🏾🙋🏼‍♂️
//:
//: Welcome to our community of [3DaysOfSwift.com](https://www.3DaysOfSwift.com) developers!
